﻿var emailTemplateEditor = {
    context: $(".email-template-editor"),
    initializeElements: function () {
        var test = $("#TemplateHTMLBody").val();
               
        $("#TemplateHTMLBody").a4richTextEditor({
            library: true,
            piping: true,
            piping_distribute: true,
            piping_system: true,
            height: 250,
            fullPage: true
        });

        $("#TemplateHTMLBody").a4richTextEditor("setContent", test);
    },
    bindEvents: function () {
        emailTemplateEditor.context.on("click", ".h-saveButton", function () {
            if (a4.validateRequiredFields($("body"))) {
                var templateId = emailTemplateId;
                var name = $(".v-name").val();
                var subject = $(".v-subject").val();
                var htmlBody = $("#TemplateHTMLBody").a4richTextEditor("getContent");
                var textBody = $("#TemplateTextBody").val();

                a4.callServerMethod(a4.getAction("UpdateSurveyTemplate", "EmailTemplates", "Library"), { templateId: templateId, name: name, subject: subject, htmlBody: htmlBody, textBody: textBody },
                function (result) {
                    a4.parent().emailTemplates.refreshDataTable();
                    modalDialog.close();
                },
                function (error) {
                    var message = eval("(" + error.responseText + ")").Message;
                    a4.showErrorMessage(message);
                });
            }
        })

        emailTemplateEditor.context.on("click", ".h-emailContentTypeSelector li", function () {
            var typeSelector = $(this).closest(".h-emailContentTypeSelector");
            var container = typeSelector.parent();
            var contentEditor = $(this).attr("data-editor");

            $("li.selected", typeSelector).removeClass("selected");
            $(this).addClass("selected");

            container.children(".v-contentContainer").hide();
            $(".v-contentContainer[data-editor='" + contentEditor + "']", container).show();
        });
    }
}

$(document).ready(function () {
    if (emailTemplateEditor.context.length > 0) {
        emailTemplateEditor.initializeElements();
        emailTemplateEditor.bindEvents();
    }
});